<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package _tk
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">

	<link rel="icon" type="image/ico" href="<?php if (get_field('favicon','options')) the_field('favicon','options'); else echo get_template_directory_uri() . '/includes/img/favicon.png'; ?>" sizes="16x16">

	<title><?php wp_title( '|', true, 'right' ); ?></title>

	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php wp_head(); ?>
	<?php if (get_field('analytics','options')) {
		the_field('analytics','options');
	} ?>
	<?php if (get_field('header_code')) {
		echo get_field('header_code');
	} ?>
</head>

<body <?php body_class(get_field('footer_position','option') . ' fixed-'.get_field('nav_fixed','option') . ' adminbar-' . is_admin_bar_showing() . ' body-gotop-' . get_field('backtop_btn_position','option')) ?>>
<?php do_action( 'before' ); ?>

<div id="fb-root"></div>
<script>(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/pl_PL/sdk.js#xfbml=1&version=v2.9";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>

<?php if (is_front_page() and get_field('start_loader','option') ) { ?>
	<div id="preloader">
		<div class="preloader__logo"></div>
	</div>
<?php } ?>

<?php if ( get_field('show_top_search','option') ) { ?>
	<div class="collapse collapseSearch" id="collapseSearch">
		<div class="panel-body">
			<div class="search-box">
				<div class="container">
					<?php get_search_form(); ?>
				</div>
			</div>
		</div>
	</div>
<?php } ?>

<?php
$social_position = get_field('social_position','option');
$contact_data_phone = get_field('contact_data_phone','option');
$contact_data_email = get_field('contact_data_email','option');
$contact_data_address = get_field('contact_data_address','option');?>

<?php if (get_field('show_upper_top_section','option')) { ?>
	<div class="upper-top-section"<?php if (get_field('show_upper_top_section_bg','option') or get_field('show_upper_top_section_txt','option')) { ?>style="<?php if (get_field('show_upper_top_section_bg','option')) echo 'background-color:'.get_field('show_upper_top_section_bg','option').';'; ?><?php if (get_field('show_upper_top_section_txt','option')) echo 'color:'.get_field('show_upper_top_section_txt','option').';'; ?>"<?php } ?>>
		<div class="container">
			<?php if (is_active_sidebar('upper-sidebar')) { ?>
				<?php dynamic_sidebar('upper-sidebar'); ?>
			<?php } ?>
			<?php if (((is_array($contact_data_phone) and in_array('top',$contact_data_phone)) or (is_array($contact_data_email) and in_array('top',$contact_data_email)) or (is_array($contact_data_address) and in_array('top',$contact_data_address)))) {
				$header_contact_position = 'top';
				include(locate_template('elements/parts/part-header-contact.php'));
			} ?>
			
			<?php if (is_array($social_position) and in_array('top',$social_position)) { ?>
				<?php if (have_rows('social_link','option') ): ?>
					<div class="social-icons social-header widget">
						<?php while ( have_rows('social_link','option') ) : the_row();
							$social_position_item = get_sub_field('service_position');
							if (is_array($social_position_item) and in_array('top',$social_position_item) and get_sub_field('link')) { ?>
								<a href="<?php the_sub_field('link'); ?>" target="_blank" class="social-<?php the_sub_field('social_service'); ?>">
									<?php if (get_sub_field('show_service_name') and get_sub_field('service_name')) { ?>
										<?php the_sub_field('service_name'); ?>
									<?php } else { ?>
										<i class="fa <?php if (get_sub_field('social_service') == 'other') the_sub_field('service_icon'); elseif (get_sub_field('social_service') == 'youtube') echo 'fa-' . get_sub_field('social_service') . '-play'; else echo 'fa-' . get_sub_field('social_service'); ?>" aria-hidden="true"<?php if (get_sub_field('service_color')) { ?> style="color: <?php the_sub_field('service_color'); ?>;"<?php } ?>></i>
									<?php } ?>
								</a>
							<?php }
						endwhile; ?>
					</div>
				<?php endif;
			} ?>
		</div>
	</div>
<?php } ?>

<?php 
if (is_array($social_position) and in_array('panel',$social_position)) { ?>
	<div class="social-panel transition social-<?php the_field('social_position_panel','option'); ?>">
		<?php if( have_rows('social_link','option') ): ?>
			<div class="social-icons social-header widget">
				<?php while ( have_rows('social_link','option') ) : the_row();
					$social_position_item = get_sub_field('service_position');
					if (is_array($social_position_item) and in_array('panel',$social_position_item) and get_sub_field('link')) { ?>
						<a href="<?php the_sub_field('link'); ?>" target="_blank" class="transition social-<?php the_field('social_service','option'); ?>">
							<?php if (get_sub_field('show_service_name') and get_sub_field('service_name')) { ?>
								<?php the_sub_field('service_name'); ?>
							<?php } else { ?>
								<i class="fa <?php if (get_sub_field('social_service') == 'other') the_sub_field('service_icon'); elseif (get_sub_field('social_service') == 'youtube') echo 'fa-' . get_sub_field('social_service') . '-play'; else echo 'fa-' . get_sub_field('social_service'); ?>"
								 <?php if (get_sub_field('service_color')) { ?> style="color: <?php the_sub_field('service_color'); ?>;"<?php } ?>></i>
							<?php } ?>
						</a>
					<?php }
				endwhile; ?>
			</div>
		<?php endif; ?>
	</div>
<?php } ?>

<nav id="navbar" class="site-navigation transition <?php if (get_field('nav_bg_color','option')) echo colorContrast(get_field('nav_bg_color','option')); else echo 'light'; ?><?php if (get_field('nav_fixed','option')) echo ' nav-fixed'; ?><?php if (get_field('nav_center','option')) echo ' nav-center'; ?>"<?php if (get_field('nav_fixed','option') or get_field('nav_affix','option')) { ?> data-spy="affix" data-offset-top="60"<?php } ?>>
	<?php if (get_field('nav_center','option')) { 
		if ((get_field('show_top_widgets','option') and is_active_sidebar( 'top-sidebar' )) or ((is_array($contact_data_phone) and in_array('header',$contact_data_phone)) or (is_array($contact_data_email) and in_array('header',$contact_data_email)) or (is_array($contact_data_address) and in_array('header',$contact_data_address)))) { ?>
			<div class="upper-navbar">
				<div class="container text-right">
					<div class="collapse navbar-collapse">
						<?php $header_contact_position = 'header';
						include(locate_template('elements/parts/part-header-contact.php')); ?>
					</div>
				</div>
			</div>
		<?php } 
	} ?>
	
	<div class="menu-box transition menu-<?php the_field('nav_center_menu','option'); ?>">
		<div class="container">
			<div class="row navbar<?php if (get_field('nav_center','option')) echo ' navbar-center'; ?>">
                <div class="pull-left left-text hidden-xs"><p>POMAGAMY NASZYM KLIENTOM</p></div>

				<div class="navbar-header">
					<!-- .navbar-toggle is used as the toggle for collapsed navbar content -->
					<button type="button" class="navbar-toggle" data-toggle="collapse" onclick="openNav()">
						<span class="sr-only"><?php _e('Toggle navigation','_tk') ?> </span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="icon-bar"></span>
						<span class="menu-text" style="color:#000;">MENU</span>
					</button>

					<!-- Your site title as branding in the menu -->

					<a class="navbar-brand<?php if (is_front_page()) echo ' wow fadeIn'; ?>" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
						<?php $logo = get_field('logo','options');
						$header_image = get_header_image();
						if ( ! empty( $header_image ) ) { ?>
							<img src="<?php header_image(); ?>" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
						<?php } elseif ($logo) { ?>
							<img src="<?php echo $logo['sizes']['medium']; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"<?php if (get_field('logo_height','option')) { ?> style="height:<?php the_field('logo_height','option'); ?>px"<?php } ?>>
						<?php } else {
							$filename = get_template_directory() . '/includes/img/logo.svg'; ?>
							<img src="<?php echo get_template_directory_uri(); ?>/includes/img/logo.<?php if (file_exists($filename)) echo 'svg'; else echo 'png'; ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"<?php if (get_field('logo_height','option')) { ?> style="height:<?php the_field('logo_height','option'); ?>px"<?php } ?>>
						<?php } ?>
					</a>
				</div>

				<?php if ((is_array($social_position) and in_array('header',$social_position)) or (get_field('nav_center','option') and get_field('nav_center_menu','option') == 'double') or !get_field('nav_center','option') or (get_field('show_top_widgets','option') and is_active_sidebar( 'top-sidebar' ))) { ?>
					<div class="top-infobox<?php if (get_field('nav_center','option')) echo ' margintop navbar-box-left';?>">

						<div class="collapse navbar-collapse">
							
							<?php if (is_array($social_position) and in_array('header',$social_position)) { ?>
								<?php if (have_rows('social_link','option') ): ?>
									<div class="social-icons social-header widget">
										<?php while ( have_rows('social_link','option') ) : the_row();
											$social_position_item = get_sub_field('service_position');
											if (is_array($social_position_item) and in_array('header',$social_position_item) and get_sub_field('link')) { ?>
												<a href="<?php the_sub_field('link'); ?>" target="_blank" class="social-<?php the_sub_field('social_service'); ?>">
													<?php if (get_sub_field('show_service_name') and get_sub_field('service_name')) { ?>
														<?php the_sub_field('service_name'); ?>
													<?php } else { ?>
														<i class="fa <?php if (get_sub_field('social_service') == 'other') the_sub_field('service_icon'); elseif (get_sub_field('social_service') == 'youtube') echo 'fa-' . get_sub_field('social_service') . '-play'; else echo 'fa-' . get_sub_field('social_service'); ?>" aria-hidden="true"<?php if (get_sub_field('service_color')) { ?> style="color: <?php the_sub_field('service_color'); ?>;"<?php } ?>></i>
													<?php } ?>
												</a>
											<?php }
										endwhile; ?>
									</div>
								<?php endif;
							} ?>
							
							<?php if (get_field('show_top_widgets','option') and is_active_sidebar( 'top-sidebar' )) : ?>
								<div class="widget-top<?php if (!get_field('nav_center','option')) echo ' pull-right'; ?>">
									<?php dynamic_sidebar( 'top-sidebar' ); ?>
								</div>
							<?php endif; ?>
							
							<?php if( have_rows('top_header_links','option') ): ?>
								<div class="row">
									<div class="col-sm-24 links-box">
										<?php $delay = 50;
										while ( have_rows('top_header_links','option') ) : the_row();
											$link_file = get_sub_field('link_file');
											$link_cat = get_sub_field('link_cat');
											if ($links_block) { ?>
												<div class="link marginbottom">
											<?php } ?>
													<a href="<?php if (get_sub_field('link_source') == 'site' and get_sub_field('link_site')) the_sub_field('link_site'); elseif (get_sub_field('link_source') == 'section' and get_sub_field('link_section')) echo '#'.get_sub_field('link_section'); elseif (get_sub_field('link_source') == 'url' and get_sub_field('link_url')) the_sub_field('link_url'); elseif (get_sub_field('link_source') == 'cat' and get_term_link($link_cat)) echo $link_file['url']; elseif (get_sub_field('link_source') == 'file' and $link_file) echo $link_file['url']; ?>" class="fadeIn <?php if (get_sub_field('link_type') == 'default') echo 'btn btn-default';  elseif (get_sub_field('link_type') == 'primary') echo 'btn btn-primary'; elseif (get_sub_field('link_type') == 'secondary') echo 'btn btn-secondary'; else echo 'normal-link'; ?>"<?php if (get_sub_field('link_source') == 'url' and (get_sub_field('link_url') or $link_file)) { ?> target="_blank"<?php } ?><?php if (get_sub_field('link_source') == 'section' and get_sub_field('link_section')) { ?> rel="scroll2id"<?php } ?> data-wow-delay="<?php echo $delay; ?>ms">
														<?php if (get_sub_field('link_content')) { ?>
															<?php the_sub_field('link_content') ?>
														<?php } else { ?>
															Czytaj więcej
														<?php } ?>
													</a>
											<?php if ($links_block) { ?>
												</div>
											<?php } ?>
										<?php $delay + 200;
										endwhile; ?>
									</div>
								</div>
							<?php endif; ?>
							
							<?php if (get_field('show_basket','option') or get_field('show_login','option') or get_field('show_top_search','option') or (get_field('show_top_widgets','option') and is_active_sidebar( 'top-sidebar' ) and get_field('nav_center','option')) or (!get_field('nav_center','option') and ((get_field('show_top_widgets','option') and is_active_sidebar( 'top-sidebar' )) or ((is_array($contact_data_phone) and in_array('header',$contact_data_phone)) or (is_array($contact_data_email) and in_array('header',$contact_data_email)) or (is_array($contact_data_address) and in_array('header',$contact_data_address)))))) { ?>
								<div class="top-infobox margintop navbar-box-right">
									<?php if (get_field('show_top_widgets','option') and is_active_sidebar( 'top-sidebar' ) and !get_field('nav_center','option') ) : ?>
										<div class="widget-top inline-block">
											<?php dynamic_sidebar( 'top-sidebar' ); ?>
										</div>
									<?php endif; ?>
									<?php if (get_field('show_top_search','option')) {
										$top_search_icon = get_field('top_search_icon','option'); ?>
										<a data-toggle="collapse" href="#collapseSearch" aria-expanded="false" aria-controls="collapseSearch"><?php if ($top_search_icon) echo '<img src="'.$top_search_icon['url'].'">'; else echo '<i class="fa fa-search" aria-hidden="true"></i>'; ?></a>
									<?php } ?>
									<?php if (get_field('show_login','option')) {
										$login_icon = get_field('login_icon','option'); ?>
										<div class="login">
											<?php if ( is_user_logged_in() ) { ?>
												<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php _e('My Account','_tk'); ?>">
													<?php if ($login_icon) echo '<img src="' . $login_icon['url'] . '"> '; else echo '<i class="fa fa-user"></i>'; ?>
													<?php if (get_field('login_title_logged','option') and !get_field('login_title_no','option')) the_field('login_title_logged','option'); elseif (!get_field('login_title_no','option')) _e('My Account','_tk'); ?>
												</a>
											 <?php } 
											 else { ?>
												<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php _e('Login / Register','_tk'); ?>">
													<?php if ($login_icon) echo '<img src="' . $login_icon['url'] . '"> '; else echo '<i class="fa fa-user"></i>'; ?>
													<?php if (get_field('login_title_guest','option') and !get_field('login_title_no','option')) the_field('login_title_guest','option'); elseif (!get_field('login_title_no','option')) _e('Login / Register','_tk'); ?>
												</a>
											 <?php } ?>
										</div>
									<?php } ?>
									<?php if (get_field('show_basket','option')) {
										$basket_icon = get_field('basket_icon','option'); ?>
										<div class="checkout">
											<?php global $woocommerce;
											if ((get_field('show_basket_rule','option') == 'show_full' and sizeof( $woocommerce->cart->get_cart_contents_count()) > 0) or get_field('show_basket_rule','option') == 'show_all') :
												echo '<a href="' . $woocommerce->cart->get_cart_url() . '" title="' . __( 'Checkout' ) . '">';
												if ($basket_icon) echo '<img src="' . $basket_icon['url'] . '"> '; else echo '<i class="fa fa-shopping-basket"></i> ';
												if (get_field('basket_title','option')) echo ' ' . get_field('basket_title','option') . ' ';
												// if (WC()->cart->get_cart_contents_count() > 0) { echo '(' . sprintf ( _n( '%d', '%d', WC()->cart->get_cart_contents_count() ), WC()->cart->get_cart_contents_count() ) . ')'; }
												if (WC()->cart->get_cart_contents_count() > 0) { echo '<span>' . sprintf ( _n( '%d', '%d', WC()->cart->get_cart_contents_count() ), WC()->cart->get_cart_contents_count() ) . '</span>'; }
												echo '</a>';
											endif; ?>
										</div>
									<?php } ?>
									<?php $header_contact_position = 'header';
									include(locate_template('elements/parts/part-header-contact.php')); ?>
								</div>
							<?php } ?>
				
							<?php if ((get_field('nav_center','option') and get_field('nav_center_menu','option') == 'double') or get_field('nav_center_menu','option') != 'single') pro_main_nav(); ?>
							
						</div>
					</div>
				<?php } ?>

				<?php if (get_field('nav_center','option') and get_field('nav_center_menu','option') == 'double' and has_nav_menu( 'primary2')) { ?>
					<div class="navbar-box-right margintop">
						<div class="collapse navbar-collapse">
							<?php pro_main2_nav(); ?>
						</div>
					</div>
				<?php } ?>

			</div>
		</div>
	</div>
	
	<?php if (get_field('nav_center_menu','option') == 'single') { ?>
		<div class="main-menu-box menu-<?php the_field('nav_center_menu','option'); ?>">
			<div class="container">
				<div class="row">
					<div class="collapse navbar-collapse">
						<div class="main-menu">
							<?php if (is_front_page())
								$nav_classes = 'nav navbar-nav navbar-center wow fadeInDown';
							else
								$nav_classes = 'nav navbar-nav navbar-center'; 
							wp_nav_menu(
							  array(
								'theme_location' 	=> 'primary',
								'depth'             => 4,
								'container'         => '',
								'container_class'   => '',
								'menu_class' 		=> $nav_classes,
								'fallback_cb' 		=> 'wp_bootstrap_navwalker::fallback',
								'menu_id'			=> 'main-menu',
								'walker' 			=> new wp_bootstrap_navwalker()
							  )
							); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	<?php } ?>
	
</nav>
<!-- The overlay --><?php $menu_bg = get_field('menu_bg','option');?>
<div id="myNav" class="overlay" style="background-image:url('<?php echo $menu_bg; ?>');background-size: cover;background-repeat: no-repeat;">

  <!-- Button to close the overlay navigation -->
  <a href="javascript:void(0)" class="closebtn" onclick="closeNav()">&times;</a>

  <!-- Overlay content -->
  <div class="overlay-content">
	<?php pro_main_nav(); ?>
  </div>

</div>
<?php if (!is_front_page() or basename(get_page_template()) != 'page-home.php') get_template_part( 'elements/content', 'banner' ); ?>

